import { initializeTheme } from './hooks/use-appearance';
import InstallPrompt from "@/components/InstallPrompt";


const appName = import.meta.env.VITE_APP_NAME || 'Laravel';

// Register Service Worker
if ("serviceWorker" in navigator) {
  window.addEventListener("load", () => {
    navigator.serviceWorker
      .register("/sw.js")
      .then((reg) => console.log("✅ Service Worker registered:", reg))
      .catch((err) => console.log("❌ Service Worker registration failed:", err));
  });
}

function App() {
  return (
    <>
      {/* ...content... */}
      <InstallPrompt />
    </>
  );
}


// This will set light / dark mode on load...
initializeTheme();
